#############################################################################
#############################################################################
#
# latexSmart.tcl (called from latex.tcl)
#
# Smart quotes, dots, subscripts, and superscripts
#
#############################################################################
#
# Original author unknown, then Tom Scavo and now:
#
# Maintainer:  Vince Darley <vince@santafe.edu>
#
#############################################################################
#############################################################################

proc latexSmart.tcl {} {}

#--------------------------------------------------------------------------
# Smart quotes:
#--------------------------------------------------------------------------

proc smartDQuote {} {
    global TeXmodeVars
    if { !$TeXmodeVars(smartQuotes) || [literalChar] } { typeText {"}; return }
    if {[leftQ]} {
	typeText {``}
    } else {
	typeText {''}
    }
}

proc smartQuote {} {
    global TeXmodeVars
    if { !$TeXmodeVars(smartQuotes) || [literalChar]  } { typeText {'}; return }
    if {[leftQ]} {
	typeText {`}
    } else {
	typeText {'}
    }
}

proc leftQ {} {
    if {[getPos] == [minPos]} { return 1 };
    return [regexp "\[\[ \t\r\n\(\{<\]" [lookAt [pos::math [getPos] - 1]]]
}

#--------------------------------------------------------------------------
# Smart dots:
#--------------------------------------------------------------------------

proc smartDots {} {
    global TeXmodeVars
    if {[isSelection]} { deleteSelection }
    if { $TeXmodeVars(smartDots) } {
	if {[lookAt [pos::math [getPos] - 1]] == "."} {
	    if {[lookAt [set begPos [pos::math [getPos] - 2]]] == "."} {
		if {![text::isEscaped $begPos]} {
		    replaceText $begPos [getPos] "\\ldots"
		    return
		}
	    }
	}
    }
    insertText "."
}

#--------------------------------------------------------------------------
# Smart subscripts and superscripts:
#--------------------------------------------------------------------------

proc smartSubscripts {} {
    smartScripts {_}
}

proc smartSuperscripts {} {
    smartScripts {^}
}

proc smartScripts {char} {
    if {[isSelection]} { deleteSelection }
    if {[literalChar]} {
	insertText $char
	return
    }
    # Filenames contain literal underscores:
    set pat {\\(usepackage|input|include(only)?|documentclass|bibliography(style)?|LoadClass|RequirePackage|begin\{filecontents\})(\[[^][]*\])?\{}
    if { [findPatJustBefore "$pat" "${pat}\[.:a-zA-Z0-9/^_-\]*\$"] != "" } {
	insertText $char
	return
    }
    if { $char == {_} } { subscript } { superscript }
}

#--------------------------------------------------------------------------
# Escapes and exceptions:
#--------------------------------------------------------------------------
if {[info tclversion] < 8.1} {
    lappend TeX::smartEscape {0 ''$ {"}} {0 ``$ {"}} {0 `$ {'}} {0 \\\\ldots$ {...}} \
      [list 2 _\{\}\\$ {_}] [list 2 \\^\{\}\\$ {^}] {1 label\{eq:\}$ {nonumber}}
} else {
    # Even with encodings on Alphatk, the above version seems to have some trouble.
    lappend TeX::smartEscape {0 ''$ {"}} {0 ``$ {"}} {0 `$ {'}} {0 \\\\ldots$ {...}} \
      [list 2 _\{\}\u2022\$ {_}] [list 2 \\^\{\}\u2022\$ {^}] {1 label\{eq:\}$ {nonumber}}
}

proc escapeSmartStuff {} {
    global TeXmodeVars
    if {![isSelection]} {
	set pos [getPos]
	set text [getText [lineStart $pos] $pos]
	global TeX::smartEscape
	foreach i [set TeX::smartEscape] {
	    set off [lindex $i 0]
	    set look [lindex $i 1]
	    if {!$TeXmodeVars(smartQuotes) \
	      && [regexp {['"`]} [string index $look 0]]} {
		continue
	    }
	    if {$off == 0} {
		if {[regexp -- $look $text got]} {
		    replaceText [pos::math $pos - [string length $got]] $pos [lindex $i 2]
		    return
		}
	    } else {
		if {[pos::compare [set end [pos::math $pos + $off]] <= [maxPos]]} {
		    if {[regexp -- $look [getText [lineStart $pos] $end] got]} {
			set pos $end
			replaceText [pos::math $pos - [string length $got]] $pos [lindex $i 2]
			return
		    }
		}
	    }
	    
	}
    }
    backSpace
}

